.nolist

;------------------------------------------------;
; Push/Pop register pair
;
; 	pushw	Z

.macro	pushw
	push	@0H
	push	@0L
.endm

.macro	popw
	pop	@0L
	pop	@0H
.endm



;------------------------------------------------;
; Load/store word from/to direct memory/immediate
;
;	ldsw	Z,mem
;	ldiw	Z,imm

.macro	ldiw
	ldi	@0L,low(@1)
	ldi	@0H,high(@1)
.endm

.macro	ldsw
	lds	@0L,@1
	lds	@0H,@1+1
.endm

.macro	ldswr
	lds	@0L,@1L
	lds	@0H,@1H
.endm

.macro	stsw
	sts	@0+1,@1H
	sts	@0,@1L
.endm

.macro	stswr
	sts	@0H,@1H
	sts	@0L,@1L
.endm


.macro	lddw
	ldd	@0L,@1
	ldd	@0H,@1+1
.endm

.macro	stdw
	std	@0+1,@1H
	std	@0,@1L
.endm

.macro	ldw
	ld	@0L,@1
	ld	@0H,@1
.endm

.macro	stw
	st	@0,@1L
	st	@0,@1H
.endm

.macro	inw
	in	@0L,@1L
	in	@0H,@1H
.endm

.macro	outw
	out	@0H,@1H
	out	@0L,@1L
.endm


;------------------------------------------------;
; Store immediate into indirect memory via r16
;
;	sti	Z,imm
;	stdi	Z+d,imm

.macro	sti
	ldi	r16,@1
	st	@0,r16
.endm

.macro	stdi
	ldi	r16,@1
	std	@0,r16
.endm

.macro	muli
	ldi	r16,@1
	mul	@0,r16
.endm


;------------------------------------------------;
; add/sub/subc/cp/cpc/lsl/lsr/rol/ror to register pair
;

.macro	addiw
	subi	@0L,low(-(@1))
	sbci	@0H,high(-(@1))
.endm

.macro	subiw
	subi	@0L,low(@1)
	sbci	@0H,high(@1)
.endm

.macro	addw
	add	@0L,@1L
	adc	@0H,@1H
.endm

.macro	adcw
	adc	@0L,@1L
	adc	@0H,@1H
.endm

.macro	subw
	sub	@0L,@1L
	sbc	@0H,@1H
.endm

.macro	sbcw
	sbc	@0L,@1L
	sbc	@0H,@1H
.endm

.macro	cpw
	cp	@0L,@1L
	cpc	@0H,@1H
.endm

.macro	cpcw
	cpc	@0L,@1L
	cpc	@0H,@1H
.endm

.macro	cpiw
	cpi	@0L,low(@1)
	ldi	r16,high(@1) 
	cpc	@0H,r16
.endm

.macro	andw
	and	@0L,@1L
	and	@0H,@1H
.endm

.macro	andiw
	andi	@0L,low(@1)
	andi	@0H,high(@1)
.endm

.macro	orw
	or	@0L,@1L
	or	@0H,@1H
.endm

.macro	oriw
	ori	@0L,low(@1)
	ori	@0H,high(@1)
.endm

.macro	lslw
	lsl	@0L
	rol	@0H
.endm

.macro	lsrw
	lsr	@0H
	ror	@0L
.endm

.macro	asrw
	asr	@0H
	ror	@0L
.endm

.macro	rolw
	rol	@0L
	rol	@0H
.endm

.macro	rorw
	ror	@0H
	ror	@0L
.endm

.macro	clrw
	clr	@0L
	clr	@0H
.endm

.macro	comw
	com	@0L
	com	@0H
.endm

.macro	negw
	com	@0H
	neg	@0L
	brne	PC+2
	inc	@0H
.endm

.macro	movew
	mov	@0L, @1L
	mov	@0H, @1H
.endm

.macro	lpmw
	lpm	@0L, @1
	lpm	@0H, @1
.endm


	

;------------------------------------------------;
; Store immediate into direct memory via r16
;
;	stsi	var,imm

.macro	stsi
	ldi	r16,@1
	sts	@0,r16
.endm


.macro	ldir
	ldi	r16,@1
	mov	@0,r16
.endm

;------------------------------------------------;
; Output port immediate via r16
;
;	outi	port,var

.macro	outi
	ldi	r16,@1
	out	@0,r16
.endm


;------------------------------------------------;
; Add immediate to register

.macro	addi
	subi	@0,-(@1)
.endm


;------------------------------------------------;
; Long branch


.macro	rjne
	breq	PC+2
	rjmp	@0
.endm

.macro	rjeq
	brne	PC+2
	rjmp	@0
.endm

.macro	rjcc
	brcs	PC+2
	rjmp	@0
.endm

.macro	rjcs
	brcc	PC+2
	rjmp	@0
.endm

.macro	rjtc
	brts	PC+2
	rjmp	@0
.endm

.macro	rjts
	brtc	PC+2
	rjmp	@0
.endm

.macro	rjge
	brlt	PC+2
	rjmp	@0
.endm

.macro	rjlt
	brge	PC+2
	rjmp	@0
.endm






.macro	rettc
	brts	PC+2
	ret
.endm

.macro	retts
	brtc	PC+2
	ret
.endm

.macro	retcc
	brcs	PC+2
	ret
.endm

.macro	retcs
	brcc	PC+2
	ret
.endm

.macro	reteq
	brne	PC+2
	ret
.endm

.macro	retne
	breq	PC+2
	ret
.endm


;------------------------------------------------;
; Move single bit between two registers
;
;	bmov	dstreg,dstbit,srcreg.srcbit

.macro	movb
	bst	@2,@3
	bld	@0,@1
.endm


.macro	outu
.if	@0 < 0x40
	out	@0,@1
.else
	sts	@0,@1
.endif
.endm

.list
